    <?php
    
	/*
	* copyright (c) 2013-2020 Heliac Technologies
	* license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
	*
	* linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
	*/
    ?>
    <h4 class="mb-4 title">Legge sui cookie</h4>
    <div class="well mb-4">
        In questa sezione è possibile inserire le impostazioni per essere in linea con la normativa GDPR vigente in Europa
    </div>

    <ul class="nav nav-tabs" id="myTab" role="tablist">
        <?php 
            foreach($lingue as $lingua) {
                if(isset($_GET["lingua"]) && $_GET["lingua"]==$lingua) {
                    echo"<li class=\"nav-item\" role=\"presentation\">
                        <a class=\"nav-link active\" data-toggle=\"tab\" href=\"#leggeCookie$lingua\" role=\"tab\" aria-controls=\"footer$lingua\" aria-selected=\"true\">$lingua</a>
                    </li>";
                }
                else if($impostazioni["linguaSito"]==$lingua && !isset($_GET["lingua"])) {
                    echo"<li class=\"nav-item\" role=\"presentation\">
                        <a class=\"nav-link active\" data-toggle=\"tab\" href=\"#leggeCookie$lingua\" role=\"tab\" aria-controls=\"footer$lingua\" aria-selected=\"true\">$lingua</a>
                    </li>";
                }
                else {
                    $linguaLetteraMaiuscola = ucfirst($lingua);
                    $classe   = ($impostazioniLingue["impostazioni$linguaLetteraMaiuscola"] == "si") ? "nav-link" : "nav-link disabled";
                    $tabIndex = ($impostazioniLingue["impostazioni$linguaLetteraMaiuscola"] == "si") ? "" : "tabindex=\"-1\"";
                    $stringaCollegamentoTab = ($impostazioniLingue["impostazioni$linguaLetteraMaiuscola"] == "si") ? "href=\"#leggeCookie$lingua\" data-toggle=\"tab\"" : "";
                    echo"<li class=\"nav-item\" role=\"presentation\">
                        <a class=\"$classe\" $tabIndex data-toggle=\"tab\" href=\"#leggeCookie$lingua\" role=\"tab\" aria-controls=\"footer$lingua\" aria-selected=\"true\">$lingua</a>
                    </li>";
                }
            }
        ?>
    </ul>
    <div class="tab-content" id="myTabContent">
    <?php 
        foreach($lingue as $lingua) {
            $linguaLetteraMaiuscola = ucfirst($lingua);
           
            $datiCookie = $geecomDb->leggiSingolaRiga("geecB_leggeCookie",$lingua,"lingua");
            if(isset($_GET["lingua"]) && $_GET["lingua"]==$lingua) {
                $classeDiv = "show active";
            }
            else if($impostazioni["linguaSito"]==$lingua && !isset($_GET["lingua"])) {
                $classeDiv = "show active";
            }
            else {
                $classeDiv = "";
            }
    ?>
        <div class="tab-pane fade  <?php echo $classeDiv ?>" id="leggeCookie<?php echo $lingua ?>" role="tabpanel" aria-labelledby="<?php echo $lingua ?>">

            <form class="form-horizontal" role="form" name="formImpostazioniCookie<?php echo $linguaLetteraMaiuscola ?>" action="../controller/controllerImpostazioni.php" method="post" enctype="multipart/form-data">
                <input type="text" class="d-none" name="operazione" value="aggiornaImpostazioniCookie">
                <input type="text" class="d-none" name="id" value="<?php echo $datiCookie["id"]; ?>">
                <input type="text" class="d-none" name="lingua" value="<?php echo $datiCookie["lingua"]; ?>">
                
                <div class="row mt-5">
                    <div class="col-12">
                        <div class="form-row">
                            <div class="form-group col-md-4">
                                <label for="select1" class="d-block">Mostra banner legge sui cookie </label>
                                <input type="checkbox" id="attivaBarraCookie<?php echo $linguaLetteraMaiuscola ?>" name=attivaBarraCookie class="js-switch" value="si" <?php
                                    if($datiCookie["attivaBarraCookie"]=="si") { // se il valore = si aggiunge la parola checked
                                      echo"CHECKED";
                                   }
                                ?> />
                            </div>
                            <div class="form-group col-md-4">
                                <label for="select1">Durata cookie (giorni)</label>
                                <input type="text" class=form-control id="durataCookie" name="durataCookie" value="<?php echo $datiCookie["durataCookie"]; ?>" />
                            </div>
                        </div>

                        <h5>Testo del banner</h5>
                        <div class="form-group">
                            <textarea class="form-control tiny" rows="8" id="testoBarraCookie<?php echo $linguaLetteraMaiuscola ?>" name="testoBarraCookie" placeholder="Inserisci qui il testo"><?php echo($datiCookie['testoBarraCookie']); ?></textarea>
                        </div>

                    </div>
                </div>

                <div class="row mt-5">
                    <div class="col-12">
                        <h5> Configurazione pulsanti </h5>
                        <hr>

                        <div class="form-row">
                            <div class="form-group col-md-4">
                                <label for="select1" >Testo pulsante "Accetto" </label>
                                <input type="text" class=form-control id="testoPulsanteAccetto" name="testoPulsanteAccetto" value="<?php echo $datiCookie["testoPulsanteAccetto"]; ?>" />
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-4">
                                <label for="mostraPulsanteNonAccetto" class="d-block">Mostra pulsante "non accetto"</label>
                                <input type="checkbox" id=mostraPulsanteNonAccetto name="mostraPulsanteNonAccetto" class="js-switch" value="si" <?php
                                    if($datiCookie["mostraPulsanteNonAccetto"]=="si") { // se il valore = si aggiunge la parola checked
                                      echo"CHECKED";
                                   }
                                ?> />
                            </div>
                            <div class="form-group col-md-4">
                                <label for="select1" >Testo pulsante "non accetto" </label>
                                <input type="text" class=form-control id="testoPulsanteNonAccetto" name="testoPulsanteNonAccetto" value="<?php echo $datiCookie["testoPulsanteNonAccetto"]; ?>" />
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-4">
                                <label for="mostraPulsanteMaggioriInformazioni" class="d-block">Mostra pulsante "maggiori informazioni" </label>
                                <input type="checkbox" id=mostraPulsanteMaggioriInformazioni name="mostraPulsanteMaggioriInformazioni" class="js-switch" value="si" <?php
                                    if($datiCookie["mostraPulsanteMaggioriInformazioni"]=="si") { // se il valore = si aggiunge la parola checked
                                      echo"CHECKED";
                                   }
                                ?> />
                            </div>

                            <div class="form-group col-md-4">
                                <label for="select1">Testo pulsante "maggiori informazioni" </label>
                                <input type="text" class=form-control id="testoPulsanteMaggioriInformazioni" name="testoPulsanteMaggioriInformazioni" value="<?php echo $datiCookie["testoPulsanteMaggioriInformazioni"]; ?>" />
                            </div>

                            <div class="form-group col-md-4">   
                                <label for="select1" >Pagina "maggiori informazioni"</label>
                                <select class="form-control" id="paginaMaggioriImpostazioni" name="paginaMaggioriImpostazioni">
                                <?php 
                                  $queryPagine = "SELECT * FROM geecB_contenuti WHERE tipo LIKE 'pagina' AND linguaContenuto LIKE 'italiano'";
                                  $risNomi = $geecomDb->eseguiQueryLettura($queryPagine);
                                  while($tag = $risNomi->fetch_assoc()) {
                                      if($datiCookie["paginaMaggioriInformazioni"]==$tag["id"]) {
                                          echo"<option value=\"{$tag["id"]}\" selected>{$tag["titolo"]}</option>";						
                                      }
                                      else {
                                          echo"<option value=\"{$tag["id"]}\">{$tag["titolo"]}</option>";
                                      }
                                  }
                                ?>          
                                </select>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="row mt-5">
                    <div class="col-12">
                        <h5>Cookie da eseguire dopo il consenso</h5>
                        <hr>
                    </div>

                    <div class="col-12">
                        <h6 class="mt-3">Codice inizio &lt;head&gt;</h6>
                        <textarea class="form-control" rows="8" id="testoArticolo" name="headCodiciCookie" placeholder="Inserisci il codice html"><?php echo($datiCookie['headCodiciCookie']); ?></textarea>
                    </div>

                    <div class="col-12">
                        <h6 class="mt-3">Codice fine &lt;body&gt;</h6>
                        <textarea class="form-control" rows="8" id="testoRiquadroIndirizzo" name="fineBodyCookie" placeholder="Inserisci il codice html"><?php echo($datiCookie['fineBodyCookie']); ?></textarea>
                    </div>
                </div>
                
                <button type="button" class="btn btn-primary float-right mt-3" onclick="document.formImpostazioniCookie<?php echo $linguaLetteraMaiuscola ?>.submit()"><i class="fas fa-check"></i> Salva</button>
            </form>
        </div>
    <?php 
        }
    ?>
    </div>
